<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("classes/searchclause.php");

add_nocache_headers();

include("include/Open_Leads_variables.php");

if(!@$_SESSION["UserID"])
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(!CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."You don't have permissions to access this table"."<a href=\"login.php\">"."Back to login page"."</a></p>";
	return;
}

$all=postvalue("all");

$pageName = "print.php";

include('include/xtempl.php');
include('classes/runnerpage.php');
$xt = new Xtempl();

$id = postvalue("id") != "" ? postvalue("id") : 1;
//array of params for classes
$params = array("pageType" => PAGE_PRINT, "id" =>$id, "tName"=>$strTableName);
$params["xt"] = &$xt;
	
$pageObject = new RunnerPage($params);


// add onload event
$onLoadJsCode = GetTableData($pageObject->tName, ".jsOnloadPrint", '');
$pageObject->addOnLoadJsEvent($onLoadJsCode);

// add button events if exist
$pageObject->addButtonHandlers();



// Modify query: remove blob fields from fieldlist.
// Blob fields on a print page are shown using imager.php (for example).
// They don't need to be selected from DB in print.php itself.
if(!postvalue("pdf"))
	$gQuery->ReplaceFieldsWithDummies(GetBinaryFieldsIndices());

//	Before Process event
if($eventObj->exists("BeforeProcessPrint"))
	$eventObj->BeforeProcessPrint($conn);

$strWhereClause="";
$strHavingClause="";

$selected_recs=array();
if (@$_REQUEST["a"]!="") 
{
	
	$sWhere = "1=0";	
	
//	process selection
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["Leadid"]=refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$selected_recs[]=$keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<1)
				continue;
			$keys=array();
			$keys["Leadid"]=urldecode($arr[0]);
			$selected_recs[]=$keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}
	$strSQL = gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
}
else
{
	$strWhereClause=@$_SESSION[$strTableName."_where"];
	$strHavingClause=@$_SESSION[$strTableName."_having"];
	$strSQL = gSQLWhere($strWhereClause, $strHavingClause);
}
if(postvalue("pdf"))
	$strWhereClause = @$_SESSION[$strTableName."_pdfwhere"];

$_SESSION[$strTableName."_pdfwhere"] = $strWhereClause;


$strOrderBy=$_SESSION[$strTableName."_order"];
if(!$strOrderBy)
	$strOrderBy=$gstrOrderBy;
$strSQL.=" ".trim($strOrderBy);

$strSQLbak = $strSQL;
if($eventObj->exists("BeforeQueryPrint"))
	$eventObj->BeforeQueryPrint($strSQL,$strWhereClause,$strOrderBy);

//	Rebuild SQL if needed

if($strSQL!=$strSQLbak)
{
//	changed $strSQL - old style	
	$numrows=GetRowCount($strSQL);
}
else
{
	$strSQL = gSQLWhere($strWhereClause, $strHavingClause);
	$strSQL.=" ".trim($strOrderBy);
	
	$rowcount=false;
	if($eventObj->exists("ListGetRowCount"))
	{
		$masterKeysReq=array();
		for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
			$masterKeysReq[]=$_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount=$eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs);
	}
	if($rowcount!==false)
		$numrows=$rowcount;
	else
	{
		$numrows = gSQLRowCount($strWhereClause, $strHavingClause);
	}
}

LogInfo($strSQL);

$mypage=(integer)$_SESSION[$strTableName."_pagenumber"];
if(!$mypage)
	$mypage=1;

//	page size
$PageSize=(integer)$_SESSION[$strTableName."_pagesize"];
if(!$PageSize)
	$PageSize = GetTableData($strTableName,".pageSize",0);

if($PageSize<0)
	$all = 1;	
	
$recno = 1;
$records = 0;	
$maxpages = 1;
$pageindex = 1;

if(!$all)
{	
	if($numrows)
	{
		$maxRecords = $numrows;
		$maxpages = ceil($maxRecords/$PageSize);
					
		if($mypage > $maxpages)
			$mypage = $maxpages;
		
		if($mypage < 1) 
			$mypage = 1;
		
		$maxrecs = $PageSize;
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj,$_SESSION[$strTableName."_arrFieldForSort"],$_SESSION[$strTableName."_arrHowFieldSort"],$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs,$PageSize,$mypage);
	if($listarray!==false)
		$rs = $listarray;
	else
	{
			if($numrows)
		{
			$strSQL.=" limit ".(($mypage-1)*$PageSize).",".$PageSize;
		}
		$rs = db_query($strSQL,$conn);
	}
	
	//	hide colunm headers if needed
	$recordsonpage = $numrows-($mypage-1)*$PageSize;
	if($recordsonpage>$PageSize)
		$recordsonpage = $PageSize;
		
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	$xt->assign("pageno",$mypage);
}
else
{
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray=$eventObj->ListQuery($pageObject->searchClauseObj,$_SESSION[$strTableName."_arrFieldForSort"],$_SESSION[$strTableName."_arrHowFieldSort"],$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs,$PageSize,$mypage);
	if($listarray!==false)
		$rs = $listarray;
	else
		$rs = db_query($strSQL,$conn);
	$recordsonpage = $numrows;
	$maxpages = ceil($recordsonpage/30);
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	
}


$fieldsArr = array();
$arr = array();
$arr['fName'] = "Leadid";
$arr['viewFormat'] = ViewFormat("Leadid", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Region";
$arr['viewFormat'] = ViewFormat("Region", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Customer Name";
$arr['viewFormat'] = ViewFormat("Customer Name", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Contact Person";
$arr['viewFormat'] = ViewFormat("Contact Person", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Lead Details";
$arr['viewFormat'] = ViewFormat("Lead Details", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Employee Name";
$arr['viewFormat'] = ViewFormat("Employee Name", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Approx Closure Date";
$arr['viewFormat'] = ViewFormat("Approx Closure Date", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Lead Status";
$arr['viewFormat'] = ViewFormat("Lead Status", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Requirement Details";
$arr['viewFormat'] = ViewFormat("Requirement Details", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "First Quote Remarks";
$arr['viewFormat'] = ViewFormat("First Quote Remarks", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Proposed Closure Date";
$arr['viewFormat'] = ViewFormat("Proposed Closure Date", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Projected Closure QTR";
$arr['viewFormat'] = ViewFormat("Projected Closure QTR", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Proposed Solution Details";
$arr['viewFormat'] = ViewFormat("Proposed Solution Details", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Final Quote Remarks";
$arr['viewFormat'] = ViewFormat("Final Quote Remarks", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Discussion Highlights";
$arr['viewFormat'] = ViewFormat("Discussion Highlights", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "WIN / Lost Analysis";
$arr['viewFormat'] = ViewFormat("WIN / Lost Analysis", $strTableName);
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "Alligned Vendor";
$arr['viewFormat'] = ViewFormat("Alligned Vendor", $strTableName);
$fieldsArr[] = $arr;
$pageObject->setGoogleMapsParams($fieldsArr);

$colsonpage=1;
if($colsonpage>$recordsonpage)
	$colsonpage=$recordsonpage;
if($colsonpage<1)
	$colsonpage=1;

	$totals=array();
	$totals["Leadid"]=0;

//	fill $rowinfo array
	$pages = array();
	$rowinfo = array();
	$rowinfo["data"]=array();
	if($eventObj->exists("ListFetchArray"))
		$data = $eventObj->ListFetchArray($rs);
	else
		$data = db_fetch_array($rs);	

	while($data)
	{
		if($eventObj->exists("BeforeProcessRowPrint"))
		{
			if(!$eventObj->BeforeProcessRowPrint($data))
			{
				if($eventObj->exists("ListFetchArray"))
					$data = $eventObj->ListFetchArray($rs);
				else
					$data = db_fetch_array($rs);
				continue;
			}
		}
		break;
	}
	
	while($data && ($all || $recno<=$PageSize))
	{
		$row=array();
		$row["grid_record"]=array();
		$row["grid_record"]["data"]=array();
		for($col=1;$data && ($all || $recno<=$PageSize) && $col<=1;$col++)
		{
			$record=array();
						$totals["Leadid"]+= ($data["Leadid"]!="");
			$recno++;
			$records++;
			$keylink="";
			$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["Leadid"]));


//	Leadid - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Leadid", ""),"field=Leadid".$keylink,"",MODE_PRINT);
			$record["Leadid_value"]=$value;

//	Region - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Region", ""),"field=Region".$keylink,"",MODE_PRINT);
			$record["Region_value"]=$value;

//	Customer Name - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Customer Name", ""),"field=Customer+Name".$keylink,"",MODE_PRINT);
			$record["Customer_Name_value"]=$value;

//	Contact Person - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Contact Person", ""),"field=Contact+Person".$keylink,"",MODE_PRINT);
			$record["Contact_Person_value"]=$value;

//	Lead Details - HTML
			$value="";
				$value = GetData($data,"Lead Details", "HTML");
			$record["Lead_Details_value"]=$value;

//	Employee Name - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Employee Name", ""),"field=Employee+Name".$keylink,"",MODE_PRINT);
			$record["Employee_Name_value"]=$value;

//	Approx Closure Date - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Approx Closure Date", ""),"field=Approx+Closure+Date".$keylink,"",MODE_PRINT);
			$record["Approx_Closure_Date_value"]=$value;

//	Lead Status - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Lead Status", ""),"field=Lead+Status".$keylink,"",MODE_PRINT);
			$record["Lead_Status_value"]=$value;

//	Requirement Details - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Requirement Details", ""),"field=Requirement+Details".$keylink,"",MODE_PRINT);
			$record["Requirement_Details_value"]=$value;

//	First Quote Remarks - 
			$value="";
				$value = ProcessLargeText(GetData($data,"First Quote Remarks", ""),"field=First+Quote+Remarks".$keylink,"",MODE_PRINT);
			$record["First_Quote_Remarks_value"]=$value;

//	Proposed Closure Date - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Proposed Closure Date", ""),"field=Proposed+Closure+Date".$keylink,"",MODE_PRINT);
			$record["Proposed_Closure_Date_value"]=$value;

//	Projected Closure QTR - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Projected Closure QTR", ""),"field=Projected+Closure+QTR".$keylink,"",MODE_PRINT);
			$record["Projected_Closure_QTR_value"]=$value;

//	Proposed Solution Details - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Proposed Solution Details", ""),"field=Proposed+Solution+Details".$keylink,"",MODE_PRINT);
			$record["Proposed_Solution_Details_value"]=$value;

//	Final Quote Remarks - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Final Quote Remarks", ""),"field=Final+Quote+Remarks".$keylink,"",MODE_PRINT);
			$record["Final_Quote_Remarks_value"]=$value;

//	Discussion Highlights - HTML
			$value="";
				$value = GetData($data,"Discussion Highlights", "HTML");
			$record["Discussion_Highlights_value"]=$value;

//	WIN / Lost Analysis - HTML
			$value="";
				$value = GetData($data,"WIN / Lost Analysis", "HTML");
			$record["WIN___Lost_Analysis_value"]=$value;

//	Alligned Vendor - 
			$value="";
				$value = ProcessLargeText(GetData($data,"Alligned Vendor", ""),"field=Alligned+Vendor".$keylink,"",MODE_PRINT);
			$record["Alligned_Vendor_value"]=$value;
			if($col<$colsonpage)
				$record["endrecord_block"]=true;
			$record["grid_recordheader"]=true;
			$record["grid_vrecord"]=true;
			
			if($eventObj->exists("BeforeMoveNextPrint"))
				$eventObj->BeforeMoveNextPrint($data,$row,$record);
				
			$row["grid_record"]["data"][]=$record;
			
			if($eventObj->exists("ListFetchArray"))
				$data = $eventObj->ListFetchArray($rs);
			else
				$data = db_fetch_array($rs);
				
			while($data)
			{
				if($eventObj->exists("BeforeProcessRowPrint"))
				{
					if(!$eventObj->BeforeProcessRowPrint($data))
					{
						if($eventObj->exists("ListFetchArray"))
							$data = $eventObj->ListFetchArray($rs);
						else
							$data = db_fetch_array($rs);
						continue;
					}
				}
				break;
			}
		}
		if($col<=$colsonpage)
		{
			$row["grid_record"]["data"][count($row["grid_record"]["data"])-1]["endrecord_block"]=false;
		}
		$row["grid_rowspace"]=true;
		$row["grid_recordspace"] = array("data"=>array());
		for($i=0;$i<$colsonpage*2-1;$i++)
			$row["grid_recordspace"]["data"][]=true;
		
		$rowinfo["data"][]=$row;
		
		if($all && $records>=30)
		{
			$page=array("grid_row" =>$rowinfo);
			$page["pageno"]=$pageindex;
			$pageindex++;
			$pages[] = $page;
			$records=0;
			$rowinfo=array();
		}
		
	}
	if(count($rowinfo))
	{
		$page=array("grid_row" =>$rowinfo);
		if($all)
			$page["pageno"]=$pageindex;
		$pages[] = $page;
	}
	
	for($i=0;$i<count($pages);$i++)
	{
	 	if($i<count($pages)-1)
			$pages[$i]["begin"]="<div name=page class=printpage>";
		else
		    $pages[$i]["begin"]="<div name=page>";
			
		$pages[$i]["end"]="</div>";
	}

	$page=array();
	$page["data"]=&$pages;
	$xt->assignbyref("page",$page);

//	show totals
//	process totals
	$record=array();
	$total=GetTotals("Leadid",$totals["Leadid"],"COUNT",$recno-1,"");
	$record["Leadid_total"]=$total;
	$record["Leadid_showtotal"]=true;
	if(count($pages))
	{
		$pages[count($pages)-1]["totals_row"]=array("data"=>array(0=>$record));
	}
	
	
//	display master table info
$mastertable=$_SESSION[$strTableName."_mastertable"];
$masterkeys=array();
if($mastertable=="Vendor Details")
{
//	include proper masterprint.php code
	include("include/Vendor_Details_masterprint.php");
	$masterkeys[]=@$_SESSION[$strTableName."_masterkey1"];
	$params=array("detailtable"=>"Open Leads","keys"=>$masterkeys);
	$master=array();
	$master["func"]="DisplayMasterTableInfo_Vendor_Details";
	$master["params"]=$params;
	$xt->assignbyref("showmasterfile",$master);
	$xt->assign("mastertable_block",true);
}

$strSQL=$_SESSION[$strTableName."_sql"];

$isPdfView = false;
if (GetTableData($strTableName, ".isUsebuttonHandlers", false) || $isPdfView || $onLoadJsCode)
{
	$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/jquery.js\"></script>\r\n";
	$pageObject->body["begin"].="<script language=\"JavaScript\" src=\"include/jsfunctions.js\"></script>\r\n";

	if ($pageObject->debugJSMode === true)
	{
		/*$pageObject->body['begin'] .= "<script type=\"text/javascript\" src=\"include/runnerJS/Runner.js\"></script>\r\n".
		"<script type=\"text/javascript\" src=\"include/runnerJS/Util.js\"></script>\r\n".
		"<script type=\"text/javascript\" src=\"include/runnerJS/Observer.js\"></script>\r\n";*/
	$pageObject->body['begin'] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
	}
	else
	{
		$pageObject->body["begin"].="<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
	}	
	$pageObject->fillSetCntrlMaps();
	$pageObject->body['end'] .= '<script>';
	$pageObject->body['end'] .= "window.controlsMap = '".jsreplace(my_json_encode($pageObject->controlsHTMLMap))."';";
	$pageObject->body['end'] .= "window.settings = '".jsreplace(my_json_encode($pageObject->jsSettings))."';";
	$pageObject->body['end'] .= '</script>';
	$pageObject->addCommonJs();		
}


if (GetTableData($strTableName, ".isUsebuttonHandlers", false) || $isPdfView || $onLoadJsCode)
	$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";

$xt->assignbyref("body",$pageObject->body);
$xt->assign("grid_block",true);

$xt->assign("Leadid_fieldheadercolumn",true);
$xt->assign("Leadid_fieldheader",true);
$xt->assign("Leadid_fieldcolumn",true);
$xt->assign("Leadid_fieldfootercolumn",true);
$xt->assign("Region_fieldheadercolumn",true);
$xt->assign("Region_fieldheader",true);
$xt->assign("Region_fieldcolumn",true);
$xt->assign("Region_fieldfootercolumn",true);
$xt->assign("Customer_Name_fieldheadercolumn",true);
$xt->assign("Customer_Name_fieldheader",true);
$xt->assign("Customer_Name_fieldcolumn",true);
$xt->assign("Customer_Name_fieldfootercolumn",true);
$xt->assign("Contact_Person_fieldheadercolumn",true);
$xt->assign("Contact_Person_fieldheader",true);
$xt->assign("Contact_Person_fieldcolumn",true);
$xt->assign("Contact_Person_fieldfootercolumn",true);
$xt->assign("Lead_Details_fieldheadercolumn",true);
$xt->assign("Lead_Details_fieldheader",true);
$xt->assign("Lead_Details_fieldcolumn",true);
$xt->assign("Lead_Details_fieldfootercolumn",true);
$xt->assign("Employee_Name_fieldheadercolumn",true);
$xt->assign("Employee_Name_fieldheader",true);
$xt->assign("Employee_Name_fieldcolumn",true);
$xt->assign("Employee_Name_fieldfootercolumn",true);
$xt->assign("Approx_Closure_Date_fieldheadercolumn",true);
$xt->assign("Approx_Closure_Date_fieldheader",true);
$xt->assign("Approx_Closure_Date_fieldcolumn",true);
$xt->assign("Approx_Closure_Date_fieldfootercolumn",true);
$xt->assign("Lead_Status_fieldheadercolumn",true);
$xt->assign("Lead_Status_fieldheader",true);
$xt->assign("Lead_Status_fieldcolumn",true);
$xt->assign("Lead_Status_fieldfootercolumn",true);
$xt->assign("Requirement_Details_fieldheadercolumn",true);
$xt->assign("Requirement_Details_fieldheader",true);
$xt->assign("Requirement_Details_fieldcolumn",true);
$xt->assign("Requirement_Details_fieldfootercolumn",true);
$xt->assign("First_Quote_Remarks_fieldheadercolumn",true);
$xt->assign("First_Quote_Remarks_fieldheader",true);
$xt->assign("First_Quote_Remarks_fieldcolumn",true);
$xt->assign("First_Quote_Remarks_fieldfootercolumn",true);
$xt->assign("Proposed_Closure_Date_fieldheadercolumn",true);
$xt->assign("Proposed_Closure_Date_fieldheader",true);
$xt->assign("Proposed_Closure_Date_fieldcolumn",true);
$xt->assign("Proposed_Closure_Date_fieldfootercolumn",true);
$xt->assign("Projected_Closure_QTR_fieldheadercolumn",true);
$xt->assign("Projected_Closure_QTR_fieldheader",true);
$xt->assign("Projected_Closure_QTR_fieldcolumn",true);
$xt->assign("Projected_Closure_QTR_fieldfootercolumn",true);
$xt->assign("Proposed_Solution_Details_fieldheadercolumn",true);
$xt->assign("Proposed_Solution_Details_fieldheader",true);
$xt->assign("Proposed_Solution_Details_fieldcolumn",true);
$xt->assign("Proposed_Solution_Details_fieldfootercolumn",true);
$xt->assign("Final_Quote_Remarks_fieldheadercolumn",true);
$xt->assign("Final_Quote_Remarks_fieldheader",true);
$xt->assign("Final_Quote_Remarks_fieldcolumn",true);
$xt->assign("Final_Quote_Remarks_fieldfootercolumn",true);
$xt->assign("Discussion_Highlights_fieldheadercolumn",true);
$xt->assign("Discussion_Highlights_fieldheader",true);
$xt->assign("Discussion_Highlights_fieldcolumn",true);
$xt->assign("Discussion_Highlights_fieldfootercolumn",true);
$xt->assign("WIN___Lost_Analysis_fieldheadercolumn",true);
$xt->assign("WIN___Lost_Analysis_fieldheader",true);
$xt->assign("WIN___Lost_Analysis_fieldcolumn",true);
$xt->assign("WIN___Lost_Analysis_fieldfootercolumn",true);
$xt->assign("Alligned_Vendor_fieldheadercolumn",true);
$xt->assign("Alligned_Vendor_fieldheader",true);
$xt->assign("Alligned_Vendor_fieldcolumn",true);
$xt->assign("Alligned_Vendor_fieldfootercolumn",true);

	$record_header=array("data"=>array());
	for($i=0;$i<$colsonpage;$i++)
	{
		$rheader=array();
		if($i<$colsonpage-1)
		{
			$rheader["endrecordheader_block"]=true;
		}
		$record_header["data"][]=$rheader;
	}
	$xt->assignbyref("record_header",$record_header);
	$xt->assign("grid_header",true);
	$xt->assign("grid_footer",true);


$templatefile = "Open_Leads_print.htm";
	
if($eventObj->exists("BeforeShowPrint"))
	$eventObj->BeforeShowPrint($xt,$templatefile);

if(!postvalue("pdf"))
	$xt->display($templatefile);
else
{
	$xt->load_template($templatefile);
	$page = $xt->fetch_loaded();
	$pagewidth=postvalue("width")*1.05;
	$pageheight=postvalue("height")*1.05;
	$landscape=false;
	if(postvalue("all"))
	{
		if($pagewidth>$pageheight)
		{
			$landscape=true;
			if($pagewidth/$pageheight<297/210)
				$pagewidth = 297/210*$pageheight;
		}
		else
		{
			if($pagewidth/$pageheight<210/297)
				$pagewidth = 210/297*$pageheight;
		}
	}
}

?>
