<?php 
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");


include("include/dbcommon.php");
include("include/Leads_Management_variables.php");
include('include/xtempl.php');
include('classes/runnerpage.php');
include("classes/searchclause.php");

add_nocache_headers();

/////////////////////////////////////////////////////////////
//	check if logged in
/////////////////////////////////////////////////////////////
if(!@$_SESSION["UserID"] || !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Edit"))
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}

/////////////////////////////////////////////////////////////
//init variables
/////////////////////////////////////////////////////////////
if(postvalue("editType")=="inline")
	$inlineedit = EDIT_INLINE;
elseif(postvalue("editType")==EDIT_POPUP)
	$inlineedit = EDIT_POPUP;
else
	$inlineedit = EDIT_SIMPLE;			

$id = postvalue("id");
if(intval($id)==0)
	$id = 1;

$flyId = $id+1;	
$xt = new Xtempl();

// assign an id		
$xt->assign("id",$id);

//array of params for classes
$params = array("pageType" => PAGE_EDIT,"id" => $id);

////////////////////// data picker
$params["calendar"] = true;

////////////////////// time picker


$params['tName'] = $strTableName;
$params['xt'] = &$xt;
$params['mode'] = $inlineedit;
$params['includes_js']=$includes_js;
$params['includes_jsreq']=$includes_jsreq;
$params['includes_css']=$includes_css;
$params['locale_info']=$locale_info;
$params['pageEditLikeInline'] = ($inlineedit == EDIT_INLINE);
//Get array of tabs for edit page
$params['useTabsOnEdit'] = useTabsOnEdit($strTableName);
if($params['useTabsOnEdit'])
	$params['arrEditTabs'] = GetEditTabs($strTableName);
$pageObject = new RunnerPage($params);

//	For ajax request 
if($_REQUEST["action"]!="")
{
	if($pageObject->lockingObj)
	{
		$arrkeys = explode("&",refine($_REQUEST["keys"]));
		foreach($arrkeys as $ind=>$val)
			$arrkeys[$ind]=urldecode($val);
		
		if($_REQUEST["action"]=="unlock")
		{
			$pageObject->lockingObj->UnlockRecord($strTableName,$arrkeys,$_REQUEST["sid"]);
			exit();	
		}
		else if($_REQUEST["action"]=="lockadmin" && (IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP))
		{
			$pageObject->lockingObj->UnlockAdmin($strTableName,$arrkeys,$_REQUEST["startEdit"]=="yes");
			if($_REQUEST["startEdit"]=="no")
				echo "unlock";
			else if($_REQUEST["startEdit"]=="yes")
				echo "lock";
			exit();	
		}
		else if($_REQUEST["action"]=="confirm")
		{echo '<br>confirm';
			if(!$pageObject->lockingObj->ConfirmLock($strTableName,$arrkeys,$message));
				echo $message;
			exit();	
		}
	}
	else
		exit();
}

$filename = $status = $message = $mesClass = $usermessage = $strWhereClause = $bodyonload = "";
$showValues = $showRawValues = $showFields = $showDetailKeys = $key = $next = $prev = array();
$HaveData = $enableCtrlsForEditing = true;
$error_happened = $readevalues = $IsSaved = false;

$templatefile = "Leads_Management_edit.htm";

$auditObj = GetAuditObject($strTableName);

// SearchClause class stuff
$pageObject->searchClauseObj->parseRequest();
$_SESSION[$strTableName.'_advsearch'] = serialize($pageObject->searchClauseObj);

//Get detail table keys	
$detailKeys = $pageObject->detailKeysByM;

//Array of fields, which appear on edit page
$editFields = $pageObject->getFieldsByPageType();

// add onload event
$onLoadJsCode = GetTableData($pageObject->tName, ".jsOnloadEdit", '');
$pageObject->addOnLoadJsEvent($onLoadJsCode);

if($pageObject->lockingObj)
{
	$system_attrs = "style='display:none;'";
	$system_message = "";
}

if ($inlineedit!=EDIT_INLINE)
{
	// add button events if exist
	$pageObject->addButtonHandlers();
}

$url_page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1,12);

//	Before Process event
if($eventObj->exists("BeforeProcessEdit"))
	$eventObj->BeforeProcessEdit($conn);

$keys = array();
$skeys = "";
$savedKeys = array();
$keys["Leadid"]=urldecode(postvalue("editid1"));
$savedKeys["Leadid"]=urldecode(postvalue("editid1"));
$skeys.=rawurlencode(postvalue("editid1"))."&";

if($skeys!="")
	$skeys = substr($skeys,0,-1);

//For show detail tables on master page edit
if($inlineedit!=EDIT_INLINE)	
{
	$dpParams = array();
	if($pageObject->isShowDetailTables)
	{
		$ids = $id;
			$mKeys["Lead-BOM"] = GetMasterKeysByDetailTable("Lead-BOM", $strTableName);
		$dpParams['strTableNames'][] = "Lead-BOM";
		$dpParams['ids'][] = ++$ids;
					$pageObject->jsSettings['tableSettings'][$strTableName]['dpParams'] = array('tableNames'=>$dpParams['strTableNames'], 'ids'=>$dpParams['ids']);
		$pageObject->AddJSFile("include/detailspreview");
	}	
}	
/////////////////////////////////////////////////////////////
//	process entered data, read and save
/////////////////////////////////////////////////////////////

// proccess captcha
if ($inlineedit!=EDIT_INLINE)
	if($pageObject->captchaExists())
		$pageObject->doCaptchaCode();

if(@$_POST["a"] == "edited")
{
	$strWhereClause = whereAdd($strWhereClause,KeyWhere($keys));
		//	select only owned records
	$strWhereClause = whereAdd($strWhereClause,SecuritySQL("Edit"));
	$oldValuesRead = false;
	if($eventObj->exists("AfterEdit") || $eventObj->exists("BeforeEdit") || $auditObj)
	{
		//	read old values
		$rsold = db_query(gSQLWhere($strWhereClause), $conn);
		$dataold = db_fetch_array($rsold);
		$oldValuesRead = true;
	}
	$evalues = $efilename_values = $blobfields = array();
	

//	processing Region - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Region_".$id);
		$type = postvalue("type_Region_".$id);
		if(FieldSubmitted("Region_".$id))
		{
				$value = prepare_for_db("Region",$value,$type);
		}
		else
			$value = false;
	
				$value = false;
		if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Region"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Region"] = $value;
		
			}
	
		}
//	processing Region - end
//	processing Customer Name - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Customer_Name_".$id);
		$type = postvalue("type_Customer_Name_".$id);
		if(FieldSubmitted("Customer Name_".$id))
		{
				$value = prepare_for_db("Customer Name",$value,$type);
		}
		else
			$value = false;
	
				$value = false;
		if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Customer Name"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Customer Name"] = $value;
		
			}
	
		}
//	processing Customer Name - end
//	processing Contact Person - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Contact_Person_".$id);
		$type = postvalue("type_Contact_Person_".$id);
		if(FieldSubmitted("Contact Person_".$id))
		{
				$value = prepare_for_db("Contact Person",$value,$type);
		}
		else
			$value = false;
	
				$value = false;
		if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Contact Person"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Contact Person"] = $value;
		
			}
	
		}
//	processing Contact Person - end
//	processing Lead Details - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Lead_Details_".$id);
		$type = postvalue("type_Lead_Details_".$id);
		if(FieldSubmitted("Lead Details_".$id))
		{
				$value = prepare_for_db("Lead Details",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Lead Details"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Lead Details"] = $value;
		
			}
	
		}
//	processing Lead Details - end
//	processing Employee Name - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Employee_Name_".$id);
		$type = postvalue("type_Employee_Name_".$id);
		if(FieldSubmitted("Employee Name_".$id))
		{
				$value = prepare_for_db("Employee Name",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Employee Name"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Employee Name"] = $value;
		
			}
	
		}
//	processing Employee Name - end
//	processing Approx Closure Date - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Approx_Closure_Date_".$id);
		$type = postvalue("type_Approx_Closure_Date_".$id);
		if(FieldSubmitted("Approx Closure Date_".$id))
		{
				$value = prepare_for_db("Approx Closure Date",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Approx Closure Date"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Approx Closure Date"] = $value;
		
			}
	
		}
//	processing Approx Closure Date - end
//	processing Lead Status - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Lead_Status_".$id);
		$type = postvalue("type_Lead_Status_".$id);
		if(FieldSubmitted("Lead Status_".$id))
		{
				$value = prepare_for_db("Lead Status",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Lead Status"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Lead Status"] = $value;
		
			}
	
		}
//	processing Lead Status - end
//	processing Requirement Details - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Requirement_Details_".$id);
		$type = postvalue("type_Requirement_Details_".$id);
		if(FieldSubmitted("Requirement Details_".$id))
		{
				$value = prepare_for_db("Requirement Details",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Requirement Details"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Requirement Details"] = $value;
		
			}
	
		}
//	processing Requirement Details - end
//	processing Approx Value - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Approx_Value_".$id);
		$type = postvalue("type_Approx_Value_".$id);
		if(FieldSubmitted("Approx Value_".$id))
		{
				$value = prepare_for_db("Approx Value",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Approx Value"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Approx Value"] = $value;
		
			}
	
		}
//	processing Approx Value - end
//	processing First Quote Remarks - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_First_Quote_Remarks_".$id);
		$type = postvalue("type_First_Quote_Remarks_".$id);
		if(FieldSubmitted("First Quote Remarks_".$id))
		{
				$value = prepare_for_db("First Quote Remarks",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "First Quote Remarks"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["First Quote Remarks"] = $value;
		
			}
	
		}
//	processing First Quote Remarks - end
//	processing Proposed Closure Date - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Proposed_Closure_Date_".$id);
		$type = postvalue("type_Proposed_Closure_Date_".$id);
		if(FieldSubmitted("Proposed Closure Date_".$id))
		{
				$value = prepare_for_db("Proposed Closure Date",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Proposed Closure Date"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Proposed Closure Date"] = $value;
		
			}
	
		}
//	processing Proposed Closure Date - end
//	processing Projected Closure QTR - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Projected_Closure_QTR_".$id);
		$type = postvalue("type_Projected_Closure_QTR_".$id);
		if(FieldSubmitted("Projected Closure QTR_".$id))
		{
				$value = prepare_for_db("Projected Closure QTR",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Projected Closure QTR"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Projected Closure QTR"] = $value;
		
			}
	
		}
//	processing Projected Closure QTR - end
//	processing Proposed Solution Details - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Proposed_Solution_Details_".$id);
		$type = postvalue("type_Proposed_Solution_Details_".$id);
		if(FieldSubmitted("Proposed Solution Details_".$id))
		{
				$value = prepare_for_db("Proposed Solution Details",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Proposed Solution Details"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Proposed Solution Details"] = $value;
		
			}
	
		}
//	processing Proposed Solution Details - end
//	processing Quoted Price - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Quoted_Price_".$id);
		$type = postvalue("type_Quoted_Price_".$id);
		if(FieldSubmitted("Quoted Price_".$id))
		{
				$value = prepare_for_db("Quoted Price",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Quoted Price"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Quoted Price"] = $value;
		
			}
	
		}
//	processing Quoted Price - end
//	processing Final Quote Remarks - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Final_Quote_Remarks_".$id);
		$type = postvalue("type_Final_Quote_Remarks_".$id);
		if(FieldSubmitted("Final Quote Remarks_".$id))
		{
				$value = prepare_for_db("Final Quote Remarks",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Final Quote Remarks"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Final Quote Remarks"] = $value;
		
			}
	
		}
//	processing Final Quote Remarks - end
//	processing Discussion Highlights - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Discussion_Highlights_".$id);
		$type = postvalue("type_Discussion_Highlights_".$id);
		if(FieldSubmitted("Discussion Highlights_".$id))
		{
				$value = prepare_for_db("Discussion Highlights",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Discussion Highlights"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Discussion Highlights"] = $value;
		
			}
	
		}
//	processing Discussion Highlights - end
//	processing WIN / Lost Analysis - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_WIN___Lost_Analysis_".$id);
		$type = postvalue("type_WIN___Lost_Analysis_".$id);
		if(FieldSubmitted("WIN / Lost Analysis_".$id))
		{
				$value = prepare_for_db("WIN / Lost Analysis",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "WIN / Lost Analysis"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["WIN / Lost Analysis"] = $value;
		
			}
	
		}
//	processing WIN / Lost Analysis - end
//	processing Alligned Vendor - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$value = postvalue("value_Alligned_Vendor_".$id);
		$type = postvalue("type_Alligned_Vendor_".$id);
		if(FieldSubmitted("Alligned Vendor_".$id))
		{
				$value = prepare_for_db("Alligned Vendor",$value,$type);
		}
		else
			$value = false;
	
			if($value!==false)
		{	
	
	
	
	
	
			if(1 && "Alligned Vendor"=="password" && $url_page=="admin_users_")
				$value = md5($value);
			$evalues["Alligned Vendor"] = $value;
		
			}
	
		}
//	processing Alligned Vendor - end

	foreach($efilename_values as $ekey=>$value)
		$evalues[$ekey] = $value;
		
	if($pageObject->lockingObj)
	{
		$lockmessage = "";
		if(!$pageObject->lockingObj->ConfirmLock($strTableName,$savedKeys,$lockmessage))
		{
			$enableCtrlsForEditing = false;
			$system_attrs = "style='display:block;'";
			if($inlineedit == EDIT_INLINE)
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$lockmessage = $pageObject->lockingObj->GetLockInfo($strTableName,$savedKeys,false,$id);
				
				$returnJSON['success'] = false;
				$returnJSON['message'] = $lockmessage;
				$returnJSON['enableCtrls'] = $enableCtrlsForEditing;
				$returnJSON['confirmTime'] = $pageObject->lockingObj->ConfirmTime;
				echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
				exit();
			}
			else
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$system_message = $pageObject->lockingObj->GetLockInfo($strTableName,$savedKeys,true,$id);
				else
					$system_message = $lockmessage;
			}
			$status = "DECLINED";
			$readevalues = true;
		}
	}
	
	if($readevalues==false)
	{
	//	do event
		$retval = true;
		if($eventObj->exists("BeforeEdit"))
			$retval=$eventObj->BeforeEdit($evalues,$strWhereClause,$dataold,$keys,$usermessage,(bool)$inlineedit);
		if($retval && $pageObject->isCaptchaOk)
		{		
			if($inlineedit!=EDIT_INLINE)
				$_SESSION[$strTableName."_count_captcha"] = $_SESSION[$strTableName."_count_captcha"]+1;
				
			if(DoUpdateRecord($strOriginalTableName,$evalues,$blobfields,$strWhereClause,$id,$pageObject))
			{
				$IsSaved = true;
				
				//	after edit event
				if($pageObject->lockingObj && $inlineedit == EDIT_INLINE)
					$pageObject->lockingObj->UnlockRecord($strTableName,$savedKeys,"");
				if($auditObj || $eventObj->exists("AfterEdit"))
				{
					foreach($dataold as $idx=>$val)
					{
						if(!array_key_exists($idx,$evalues))
							$evalues[$idx] = $val;
					}
				}

				if($auditObj)
					$auditObj->LogEdit($strTableName,$evalues,$dataold,$keys);
				if($eventObj->exists("AfterEdit"))
					$eventObj->AfterEdit($evalues,KeyWhere($keys),$dataold,$keys,(bool)$inlineedit);
							
				$mesClass = "mes_ok";	
			}
			elseif($inlineedit!=EDIT_INLINE)
				$mesClass = "mes_not";	
		}
		else
		{
			$message = $usermessage;
			$readevalues = true;
			$status = "DECLINED";
		}
	}
	if($readevalues)
		$keys = $savedKeys;
}
//else
{
	/////////////////////////
	//Locking recors
	/////////////////////////

	if($pageObject->lockingObj)
	{
		$enableCtrlsForEditing = $pageObject->lockingObj->LockRecord($strTableName,$keys);
		if(!$enableCtrlsForEditing)
		{
			if($inlineedit == EDIT_INLINE)
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$lockmessage = $pageObject->lockingObj->GetLockInfo($strTableName,$keys,false,$id);
				else
					$lockmessage = $pageObject->lockingObj->LockUser;
				$returnJSON['success'] = false;
				$returnJSON['message'] = $lockmessage;
				$returnJSON['enableCtrls'] = $enableCtrlsForEditing;
				$returnJSON['confirmTime'] = $pageObject->lockingObj->ConfirmTime;
				echo my_json_encode($returnJSON);
				exit();
			}
			
			$system_attrs = "style='display:block;'";
			$system_message = $pageObject->lockingObj->LockUser;
			
			if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
			{
				$rb = $pageObject->lockingObj->GetLockInfo($strTableName,$keys,true,$id);
				if($rb!="")
					$system_message = $rb;
			}
		}
	}
}

if($pageObject->lockingObj && $inlineedit!=EDIT_INLINE)
	$pageObject->body["begin"] .='<div id="system_div'.$id.'" class="admin_message" '.$system_attrs.'>'.$system_message.'</div>';

$message = "<div class='message ".$mesClass."'>".$message."</div>";

// PRG rule, to avoid POSTDATA resend
if ($IsSaved && no_output_done() && $inlineedit == EDIT_SIMPLE)
{
	// saving message
	$_SESSION["message"] = ($message ? $message : "");
	// key get query
	$keyGetQ = "";
		$keyGetQ.="editid1=".rawurldecode($keys["Leadid"])."&";
	// cut last &
	$keyGetQ = substr($keyGetQ, 0, strlen($keyGetQ)-1);	
	// redirect
	header("Location: Leads_Management_".$pageObject->getPageType().".php?".$keyGetQ);
	// turned on output buffering, so we need to stop script
	exit();
}
// for PRG rule, to avoid POSTDATA resend. Saving mess in session
if ($inlineedit == EDIT_SIMPLE && isset($_SESSION["message"]))
{
	$message = $_SESSION["message"];
	unset($_SESSION["message"]);
}

/////////////////////////////////////////////////////////////
//	read current values from the database
/////////////////////////////////////////////////////////////
$query = $queryData_Leads_Management->Copy();

$strWhereClause = KeyWhere($keys);
//	select only owned records
$strWhereClause = whereAdd($strWhereClause,SecuritySQL("Edit"));
$strSQL = gSQLWhere($strWhereClause);

$strSQLbak = $strSQL;
//	Before Query event
if($eventObj->exists("BeforeQueryEdit"))
	$eventObj->BeforeQueryEdit($strSQL, $strWhereClause);

if($strSQLbak == $strSQL)
	$strSQL = gSQLWhere($strWhereClause);
	
LogInfo($strSQL);

$rs = db_query($strSQL, $conn);
$data = db_fetch_array($rs);
if(!$data)
{
	if($inlineedit == EDIT_SIMPLE)
	{
		header("Location: Leads_Management_list.php?a=return");
		exit();
	}
	else
		$data = array();
}

$readonlyfields = array();

  $readonlyfields["Region"] = htmlspecialchars(GetData($data,"Region", ""));
  $readonlyfields["Customer Name"] = htmlspecialchars(GetData($data,"Customer Name", ""));
  $readonlyfields["Contact Person"] = htmlspecialchars(GetData($data,"Contact Person", ""));

if($readevalues)
{
	$data["Lead Details"] = $evalues["Lead Details"];
	$data["Employee Name"] = $evalues["Employee Name"];
	$data["Approx Closure Date"] = $evalues["Approx Closure Date"];
	$data["Lead Status"] = $evalues["Lead Status"];
	$data["Requirement Details"] = $evalues["Requirement Details"];
	$data["Approx Value"] = $evalues["Approx Value"];
	$data["First Quote Remarks"] = $evalues["First Quote Remarks"];
	$data["Proposed Closure Date"] = $evalues["Proposed Closure Date"];
	$data["Projected Closure QTR"] = $evalues["Projected Closure QTR"];
	$data["Proposed Solution Details"] = $evalues["Proposed Solution Details"];
	$data["Quoted Price"] = $evalues["Quoted Price"];
	$data["Final Quote Remarks"] = $evalues["Final Quote Remarks"];
	$data["Discussion Highlights"] = $evalues["Discussion Highlights"];
	$data["WIN / Lost Analysis"] = $evalues["WIN / Lost Analysis"];
	$data["Alligned Vendor"] = $evalues["Alligned Vendor"];
}

if($eventObj->exists("ProcessValuesEdit"))
	$eventObj->ProcessValuesEdit($data);

/////////////////////////////////////////////////////////////
//	assign values to $xt class, prepare page for displaying
/////////////////////////////////////////////////////////////
//Basic includes js files
$includes = "";
//javascript code
	
if($inlineedit != EDIT_INLINE)
{
	if($inlineedit == EDIT_SIMPLE)
	{
		$includes.= "<script language=\"JavaScript\" src=\"include/jquery.js\"></script>\r\n";
			
		if ($pageObject->debugJSMode === true)
		{
			/*$includes.="<script type=\"text/javascript\" src=\"include/runnerJS/Runner.js\"></script>\r\n".
				"<script type=\"text/javascript\" src=\"include/runnerJS/Util.js\"></script>\r\n".
				"<script type=\"text/javascript\" src=\"include/runnerJS/Observer.js\"></script>\r\n";*/
			$includes.="<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
		}
		else
			$includes.= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerBase.js\"></script>\r\n";
			
		$includes.= "<script language=\"JavaScript\" src=\"include/jsfunctions.js\"></script>\r\n";
		$includes.= "<div id=\"search_suggest".$id."\"></div>\r\n";
		if($pageObject->isShowDetailTables)
			$includes.= "<div id=\"master_details\" onmouseover=\"RollDetailsLink.showPopup();\" onmouseout=\"RollDetailsLink.hidePopup();\"> </div>";
		$pageObject->body["begin"].= $includes;
	}	

	if(!$pageObject->isAppearOnTabs("Region"))
		$xt->assign("Region_fieldblock",true);
	else
		$xt->assign("Region_tabfieldblock",true);
	$xt->assign("Region_label",true);
	if(isEnableSection508())
		$xt->assign_section("Region_label","<label for=\"".GetInputElementId("Region", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Customer Name"))
		$xt->assign("Customer_Name_fieldblock",true);
	else
		$xt->assign("Customer_Name_tabfieldblock",true);
	$xt->assign("Customer_Name_label",true);
	if(isEnableSection508())
		$xt->assign_section("Customer_Name_label","<label for=\"".GetInputElementId("Customer Name", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Contact Person"))
		$xt->assign("Contact_Person_fieldblock",true);
	else
		$xt->assign("Contact_Person_tabfieldblock",true);
	$xt->assign("Contact_Person_label",true);
	if(isEnableSection508())
		$xt->assign_section("Contact_Person_label","<label for=\"".GetInputElementId("Contact Person", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Lead Details"))
		$xt->assign("Lead_Details_fieldblock",true);
	else
		$xt->assign("Lead_Details_tabfieldblock",true);
	$xt->assign("Lead_Details_label",true);
	if(isEnableSection508())
		$xt->assign_section("Lead_Details_label","<label for=\"".GetInputElementId("Lead Details", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Employee Name"))
		$xt->assign("Employee_Name_fieldblock",true);
	else
		$xt->assign("Employee_Name_tabfieldblock",true);
	$xt->assign("Employee_Name_label",true);
	if(isEnableSection508())
		$xt->assign_section("Employee_Name_label","<label for=\"".GetInputElementId("Employee Name", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Approx Closure Date"))
		$xt->assign("Approx_Closure_Date_fieldblock",true);
	else
		$xt->assign("Approx_Closure_Date_tabfieldblock",true);
	$xt->assign("Approx_Closure_Date_label",true);
	if(isEnableSection508())
		$xt->assign_section("Approx_Closure_Date_label","<label for=\"".GetInputElementId("Approx Closure Date", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Lead Status"))
		$xt->assign("Lead_Status_fieldblock",true);
	else
		$xt->assign("Lead_Status_tabfieldblock",true);
	$xt->assign("Lead_Status_label",true);
	if(isEnableSection508())
		$xt->assign_section("Lead_Status_label","<label for=\"".GetInputElementId("Lead Status", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Requirement Details"))
		$xt->assign("Requirement_Details_fieldblock",true);
	else
		$xt->assign("Requirement_Details_tabfieldblock",true);
	$xt->assign("Requirement_Details_label",true);
	if(isEnableSection508())
		$xt->assign_section("Requirement_Details_label","<label for=\"".GetInputElementId("Requirement Details", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Approx Value"))
		$xt->assign("Approx_Value_fieldblock",true);
	else
		$xt->assign("Approx_Value_tabfieldblock",true);
	$xt->assign("Approx_Value_label",true);
	if(isEnableSection508())
		$xt->assign_section("Approx_Value_label","<label for=\"".GetInputElementId("Approx Value", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("First Quote Remarks"))
		$xt->assign("First_Quote_Remarks_fieldblock",true);
	else
		$xt->assign("First_Quote_Remarks_tabfieldblock",true);
	$xt->assign("First_Quote_Remarks_label",true);
	if(isEnableSection508())
		$xt->assign_section("First_Quote_Remarks_label","<label for=\"".GetInputElementId("First Quote Remarks", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Proposed Closure Date"))
		$xt->assign("Proposed_Closure_Date_fieldblock",true);
	else
		$xt->assign("Proposed_Closure_Date_tabfieldblock",true);
	$xt->assign("Proposed_Closure_Date_label",true);
	if(isEnableSection508())
		$xt->assign_section("Proposed_Closure_Date_label","<label for=\"".GetInputElementId("Proposed Closure Date", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Projected Closure QTR"))
		$xt->assign("Projected_Closure_QTR_fieldblock",true);
	else
		$xt->assign("Projected_Closure_QTR_tabfieldblock",true);
	$xt->assign("Projected_Closure_QTR_label",true);
	if(isEnableSection508())
		$xt->assign_section("Projected_Closure_QTR_label","<label for=\"".GetInputElementId("Projected Closure QTR", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Proposed Solution Details"))
		$xt->assign("Proposed_Solution_Details_fieldblock",true);
	else
		$xt->assign("Proposed_Solution_Details_tabfieldblock",true);
	$xt->assign("Proposed_Solution_Details_label",true);
	if(isEnableSection508())
		$xt->assign_section("Proposed_Solution_Details_label","<label for=\"".GetInputElementId("Proposed Solution Details", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Quoted Price"))
		$xt->assign("Quoted_Price_fieldblock",true);
	else
		$xt->assign("Quoted_Price_tabfieldblock",true);
	$xt->assign("Quoted_Price_label",true);
	if(isEnableSection508())
		$xt->assign_section("Quoted_Price_label","<label for=\"".GetInputElementId("Quoted Price", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Final Quote Remarks"))
		$xt->assign("Final_Quote_Remarks_fieldblock",true);
	else
		$xt->assign("Final_Quote_Remarks_tabfieldblock",true);
	$xt->assign("Final_Quote_Remarks_label",true);
	if(isEnableSection508())
		$xt->assign_section("Final_Quote_Remarks_label","<label for=\"".GetInputElementId("Final Quote Remarks", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Discussion Highlights"))
		$xt->assign("Discussion_Highlights_fieldblock",true);
	else
		$xt->assign("Discussion_Highlights_tabfieldblock",true);
	$xt->assign("Discussion_Highlights_label",true);
	if(isEnableSection508())
		$xt->assign_section("Discussion_Highlights_label","<label for=\"".GetInputElementId("Discussion Highlights", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("WIN / Lost Analysis"))
		$xt->assign("WIN___Lost_Analysis_fieldblock",true);
	else
		$xt->assign("WIN___Lost_Analysis_tabfieldblock",true);
	$xt->assign("WIN___Lost_Analysis_label",true);
	if(isEnableSection508())
		$xt->assign_section("WIN___Lost_Analysis_label","<label for=\"".GetInputElementId("WIN / Lost Analysis", $id)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("Alligned Vendor"))
		$xt->assign("Alligned_Vendor_fieldblock",true);
	else
		$xt->assign("Alligned_Vendor_tabfieldblock",true);
	$xt->assign("Alligned_Vendor_label",true);
	if(isEnableSection508())
		$xt->assign_section("Alligned_Vendor_label","<label for=\"".GetInputElementId("Alligned Vendor", $id)."\">","</label>");
		

	$xt->assign("show_key1", htmlspecialchars(GetData($data,"Leadid", "")));
	//$xt->assign('editForm',true);
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Begin Next Prev button
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
	if(!@$_SESSION[$strTableName."_noNextPrev"] && $inlineedit == EDIT_SIMPLE)
	{
		$next = array();
		$prev = array();
		$pageObject->getNextPrevRecordKeys($data,"Edit",$next,$prev);
	}
	$nextlink = $prevlink = "";
	if(count($next))
	{
		$xt->assign("next_button",true);
				$nextlink.= "editid1=".htmlspecialchars(rawurlencode($next[1]));
		$xt->assign("nextbutton_attrs","id=\"nextButton".$id."\" align=\"absmiddle\"");
	}
	else 
		$xt->assign("next_button",false);
	if(count($prev))
	{
		$xt->assign("prev_button",true);
				$prevlink.= "editid1=".htmlspecialchars(rawurlencode($prev[1]));
		$xt->assign("prevbutton_attrs","id=\"prevButton".$id."\" align=\"absmiddle\"");
	}
	else 
		$xt->assign("prev_button",false);
	
	
	$xt->assign("resetbutton_attrs",'id="resetButton'.$id.'"');
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//End Next Prev button
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
	if($inlineedit == EDIT_SIMPLE)
	{
		$xt->assign("back_button",true);
		$xt->assign("backbutton_attrs","id=\"backButton".$id."\"");
	}
	// onmouseover event, for changing focus. Needed to proper submit form
	$onmouseover = "this.focus();";
	$onmouseover = 'onmouseover="'.$onmouseover.'"';
	
	$xt->assign("save_button",true);
	if(!$enableCtrlsForEditing)
		$xt->assign("savebutton_attrs", "id=\"saveButton".$id."\" disabled=\"true\" style='background-color:#dcdcdc' ".$onmouseover);
	else
		$xt->assign("savebutton_attrs", "id=\"saveButton".$id."\"".$onmouseover);
		
	$xt->assign("reset_button",true);
}

if($message)
{
	$xt->assign("message_block",true);
	$xt->assign("message",$message);
}
/////////////////////////////////////////////////////////////
//process readonly and auto-update fields
/////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
//	prepare Edit Controls
/////////////////////////////////////////////////////////////
//	validation stuff
$regex = '';
$regexmessage = '';
$regextype = '';
$control = array();

foreach($editFields as $fName)
{
	$gfName = GoodFieldName($fName);
	$controls = array('controls'=>array());
	if (!$detailKeys || !in_array($fName, $detailKeys))
	{		
		$control[$gfName] = array();
		$control[$gfName]["func"]="xt_buildeditcontrol";
		$control[$gfName]["params"] = array();
		$control[$gfName]["params"]["id"] = $id;
		$control[$gfName]["params"]["field"] = $fName;
		$control[$gfName]["params"]["value"] = @$data[$fName];
		
		//	Begin Add validation
		$arrValidate = getValidation($fName,$strTableName);	
		$control[$gfName]["params"]["validate"] = $arrValidate;
		//	End Add validation	
		$additionalCtrlParams = array();
		$additionalCtrlParams["disabled"] = !$enableCtrlsForEditing;
		$control[$gfName]["params"]["additionalCtrlParams"] = $additionalCtrlParams;
	}
	$controls["controls"]['ctrlInd'] = 0;
	$controls["controls"]['id'] = $id;
	$controls["controls"]['fieldName'] = $fName;
	
	if($inlineedit == EDIT_INLINE)
	{
		if(!$detailKeys || !in_array($fName, $detailKeys))
			$control[$gfName]["params"]["mode"]="inline_edit";
		$controls["controls"]['mode'] = "inline_edit";
	}
	else{
			if (!$detailKeys || !in_array($fName, $detailKeys))
				$control[$gfName]["params"]["mode"] = "edit";
			$controls["controls"]['mode'] = "edit";
		}
                                                                        	
	if(!$detailKeys || !in_array($fName, $detailKeys))
		$xt->assignbyref($gfName."_editcontrol",$control[$gfName]);
	elseif($detailKeys && in_array($fName, $detailKeys))
		$controls["controls"]['value'] = @$data[$fName];
		
	// category control field
	$strCategoryControl = $pageObject->hasDependField($fName);
	
	if($strCategoryControl!==false && in_array($strCategoryControl, $editFields))
		$vals = array($fName => @$data[$fName],$strCategoryControl => @$data[$strCategoryControl]);
	else
		$vals = array($fName => @$data[$fName]);
		
	$preload = $pageObject->fillPreload($fName, $vals);
	if($preload!==false)
		$controls["controls"]['preloadData'] = $preload;	
	
	$pageObject->fillControlsMap($controls);
	
	//fill field tool tips
	$pageObject->fillFieldToolTips($fName);
	
	// fill special settings for timepicker
	if(GetEditFormat($fName) == 'Time')	
		$pageObject->fillTimePickSettings($fName, $data[$fName]);
	
	if(ViewFormat($fName) == FORMAT_MAP)	
		$pageObject->googleMapCfg['isUseGoogleMap'] = true;
		
	if($detailKeys && in_array($fName, $detailKeys) && array_key_exists($fName, $data))
	{
		if((GetEditFormat($fName)==EDIT_FORMAT_LOOKUP_WIZARD || GetEditFormat($fName)==EDIT_FORMAT_RADIO) && GetpLookupType($fName) == LT_LOOKUPTABLE)
			$value=DisplayLookupWizard($fName,$data[$fName],$data,"",MODE_VIEW);
		elseif(NeedEncode($fName))
			$value = ProcessLargeText(GetData($data,$fName, ViewFormat($fName)),"field=".rawurlencode(htmlspecialchars($fName)),"",MODE_VIEW);
		else
			$value = GetData($data,$fName, ViewFormat($fName));
		
		$xt->assign($gfName."_editcontrol",$value);
	}
}
//fill tab groups name and sections name to controls
$pageObject->fillCntrlTabGroups();
			
$pageObject->jsSettings['tableSettings'][$strTableName]["keys"] = $keys;
$pageObject->jsSettings['tableSettings'][$strTableName]["prevKeys"] = $prev;
$pageObject->jsSettings['tableSettings'][$strTableName]["nextKeys"] = $next; 
if($pageObject->lockingObj)
{
	$pageObject->jsSettings['tableSettings'][$strTableName]["sKeys"] = $skeys;
	$pageObject->jsSettings['tableSettings'][$strTableName]["enableCtrls"] = $enableCtrlsForEditing;
	$pageObject->jsSettings['tableSettings'][$strTableName]["confirmTime"] = $pageObject->lockingObj->ConfirmTime;
}
//fill jsSettings and ControlsHTMLMap
$pageObject->fillSetCntrlMaps();

/////////////////////////////////////////////////////////////
if($pageObject->isShowDetailTables && $inlineedit!=EDIT_INLINE)
{
	$options = array();
	//array of params for classes
	$options["mode"] = LIST_DETAILS;
	$options["pageType"] = PAGE_LIST;
	$options["masterPageType"] = PAGE_EDIT;
	$options["mainMasterPageType"] = PAGE_EDIT;
	$options['masterTable'] = $strTableName;
	$options['firstTime'] = 1;
	
	if(count($dpParams['ids']))
	{
		include('classes/listpage.php');
		include('classes/listpage_embed.php');
		include('classes/listpage_dpinline.php');
		$xt->assign("detail_tables",true);	
	}
	
	$dControlsMap = array();
	
	$flyId = $ids+1;
	for($d=0;$d<count($dpParams['ids']);$d++)
	{
		$strTableName = $dpParams['strTableNames'][$d];
		include("include/".GetTableURL($strTableName)."_settings.php");
		if(!CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Search"))
		{
			$strTableName = "Leads-Management";		
			continue;
		}
		$options['xt'] = new Xtempl();
		$options['id'] = $dpParams['ids'][$d];
		$options['flyId'] = $flyId++;
		$mkr=1;
		foreach($mKeys[$strTableName] as $mk)
			$options['masterKeysReq'][$mkr++] = $data[$mk];

		$listPageObject = ListPage::createListPage($strTableName, $options);
		// prepare code
		$listPageObject->prepareForBuildPage();
		$flyId = $listPageObject->recId+1;
		// show page
		if($listPageObject->isDispGrid())
		{
			//add detail settings to master settings
			$listPageObject->fillSetCntrlMaps();
			$pageObject->jsSettings['tableSettings'][$strTableName]	= $listPageObject->jsSettings['tableSettings'][$strTableName];				
			$dControlsMap[$strTableName]['gridRows'] = $listPageObject->controlsHTMLMap[$strTableName][PAGE_LIST][$dpParams['ids'][$d]]['gridRows'];
			$dControlsMap[$strTableName]['video'] = $listPageObject->controlsHTMLMap[$strTableName][PAGE_LIST][$dpParams['ids'][$d]]['video'];
			$dControlsMap[$strTableName]['gMaps'] = $listPageObject->controlsHTMLMap[$strTableName][PAGE_LIST][$dpParams['ids'][$d]]['gMaps'];
			foreach($listPageObject->jsSettings['global']['shortTNames'] as $key=>$val)
			{
				if(!array_key_exists($key,$pageObject->jsSettings['global']['shortTNames']))
					$pageObject->jsSettings['global']['shortTNames'][$key] = $val;
			}			
			
			//Add detail's js files to master's files
			$pageObject->copyAllJSFiles($listPageObject->grabAllJSFiles());
			
			//Add detail's css files to master's files	
			$pageObject->copyAllCSSFiles($listPageObject->grabAllCSSFiles());
		}
		$xt->assign("displayDetailTable_".GoodFieldName($strTableName), array("func" => "showDetailTable","params" => array("dpObject" => $listPageObject, "dpParams" => $strTableName)));
	}	
	$strTableName = "Leads-Management";
	$pageObject->controlsHTMLMap[$strTableName][PAGE_EDIT][$id]['dControlsMap'] = $dControlsMap;	
}
/////////////////////////////////////////////////////////////	

if($inlineedit == EDIT_SIMPLE)
{
	$pageObject->jsSettings["global"]['idStartFrom'] =  $flyId + 1;
	$pageObject->body['end'].= '<script>';
	$pageObject->body['end'].= "window.controlsMap = '".jsreplace(my_json_encode($pageObject->controlsHTMLMap))."';";
	$pageObject->body['end'].= "window.settings = '".jsreplace(my_json_encode($pageObject->jsSettings))."';";
	$pageObject->body['end'].= '</script>';
}
else{
		$returnJSON['controlsMap'] = $pageObject->controlsHTMLMap;
		//if($isNeedSettings)
		$returnJSON['settings'] = $pageObject->jsSettings;	
	}
	
$pageObject->addCommonJs();

$jscode = $pageObject->PrepareJS();

if($inlineedit==EDIT_SIMPLE)
{
	$pageObject->body["end"].= "<script>".$jscode."</script>";
	$xt->assign("body",$pageObject->body);
	$xt->assign("flybody",true);	
}
elseif($inlineedit==EDIT_POPUP){
		$xt->assign("footer","");
		$xt->assign("flybody",$pageObject->body);
		$xt->assign("body",true);
	}
	
$xt->assign("style_block",true);
$pageObject->xt->assign("legend", true);



/////////////////////////////////////////////////////////////
//display the page
/////////////////////////////////////////////////////////////
if($eventObj->exists("BeforeShowEdit"))
	$eventObj->BeforeShowEdit($xt,$templatefile,$data);
if($inlineedit==EDIT_POPUP)
{
	$xt->load_template($templatefile);
	$returnJSON['html'] = $xt->fetch_loaded('style_block').$xt->fetch_loaded('flybody');
	if($pageObject->isShowDetailTables)
		$returnJSON['html'].= $xt->fetch_loaded('detail_tables');
	$returnJSON['idStartFrom'] = $flyId + 1;
	echo (my_json_encode($returnJSON)); 
}
elseif($inlineedit == EDIT_INLINE)
{
	$xt->load_template($templatefile);
	$returnJSON["html"] = array();
	foreach($editFields as $fName)
	{
		if($detailKeys && in_array($fName, $detailKeys))
			continue;
		$returnJSON["html"][$fName] = $xt->fetchVar(GoodFieldName($fName)."_editcontrol");	
	}
	
	echo (my_json_encode($returnJSON)); 
}
else	
	$xt->display($templatefile);

?>
